#ifndef MOC_H
#define MOC_H
// <<< Use Configuration Wizard in Context Menu >>>
// <h> Set MOTOR_CONT1 
// <o.5> MPWMEN <0=> Disable <1=> Enable 
// <o.6> MPWMSEL <0=> From Register <1=> From SVPWM Register
// </h>
#define MOTOR_CONT1_REGS 0x60

// <h> Set MOTOR_CONT2 
// <o.4> SVPWMMODE <0=> 7-SVPWM <1=> 5-SVPWM 
// </h>
#define MOTOR_CONT2_REGS 0x00

// <h> Set SVPWM_AMP 
// <o> SVPWM_AMP <0-0x4900>
// </h>
#define SVPWM_AMP_REGS 0x4000

// <h> PI_GAIN 
// <o.0> PLL KI Gain x16 <0=> Disable <1=> Enable
// <o.1> PLL KP Gain x16 <0=> Disable <1=> Enable
// <o.2> SPEED KI Gain x16 <0=> Disable <1=> Enable
// <o.3> SPEED KP Gain x16 <0=> Disable <1=> Enable
// <o.4> ID KI Gain x16 <0=> Disable <1=> Enable
// <o.5> ID KP Gain x16 <0=> Disable <1=> Enable
// <o.6> IQ KI Gain x16 <0=> Disable <1=> Enable
// <o.7> IQ KP Gain x16 <0=> Disable <1=> Enable
// </h>
#define PI_GAIN_REGS 0x0B

// <h> FOCCONT 
// <o.4..6> ESTCR 
// <0=> Current Value x1 <1=> Current Value x2 <2=> Current Value x4 <3=> Current Value x8
// <4=> Current Value /2 <5=> Current Value /4 <6=> Current Value /8 <7=> Current Value /16
// </h>
#define FOCCONT_REGS 0x00

// <<< end of configuration section >>>
#endif